<?php
// Test script to verify PHP 5.6 compatibility
echo "PHP Version: " . phpversion() . "\n";

// Test if required functions are available
$functions_to_check = array(
    'preg_match',
    'preg_replace',
    'session_start',
    'file_get_contents',
    'file_put_contents'
);

foreach ($functions_to_check as $function) {
    if (function_exists($function)) {
        echo "Function $function: Available\n";
    } else {
        echo "Function $function: NOT AVAILABLE\n";
    }
}

// Test basic regex functionality
$test_string = "test@example.com";
if (preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*$/i", $test_string)) {
    echo "Regex test: PASSED\n";
} else {
    echo "Regex test: FAILED\n";
}

echo "Compatibility check completed.\n";
?>